/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.apache.http.protocol;

import java.io.IOException;
import net.creeperhost.minetogether.org.apache.http.HttpEntityEnclosingRequest;
import net.creeperhost.minetogether.org.apache.http.HttpException;
import net.creeperhost.minetogether.org.apache.http.HttpRequest;
import net.creeperhost.minetogether.org.apache.http.HttpRequestInterceptor;
import net.creeperhost.minetogether.org.apache.http.annotation.Contract;
import net.creeperhost.minetogether.org.apache.http.annotation.ThreadingBehavior;
import net.creeperhost.minetogether.org.apache.http.protocol.HttpContext;
import net.creeperhost.minetogether.org.apache.http.protocol.HttpDateGenerator;
import net.creeperhost.minetogether.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

